# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 9
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR9_strategy.txt
# LLM Suggested Fallback: C

def harmonious_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Early rounds: unconditional cooperation
    if current_round <= 3:
        return "C"
    
    # Middle rounds: Tit-for-Tat with a twist
    if 4 <= current_round <= 7:
        if "D" in opp_history:
            return opp_history[-1]
        else:
            return "C"
    
    # Late rounds: analyze opponent's code for planned defection
    if current_round >= 8:
        if "current_round == 9: return \"D\"" in opponent_program_code or \
           "current_round == 10: return \"D\"" in opponent_program_code or \
           "round >= 8" in opponent_program_code and "return \"D\"" in opponent_program_code:
            return "D"
        else:
            if "D" in opp_history:
                return opp_history[-1]
            else:
                return "C"
    
    # Default fallback (shouldn't reach here)
    return "C"